/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class MomentInTime {
    protected String timeZoneName;
    protected Calendar moment;

    public static MomentInTime now() {
        return new MomentInTime();
    }

    public static MomentInTime now(TimeZone timeZone) {
        return MomentInTime.now().convert(timeZone);
    }

    public MomentInTime() {
        this.moment = new GregorianCalendar();
    }

    public MomentInTime(Date date, TimeZone timeZone) {
        this.moment = new GregorianCalendar(timeZone);
        this.moment.setTime(date);
    }

    public String getTimeZoneName() {
        return this.timeZoneName == null ? this.getTimeZone().getDisplayName() : this.timeZoneName;
    }

    public void setTimeZoneName(String string) {
        this.timeZoneName = string;
    }

    public Date getDate() {
        return this.moment.getTime();
    }

    public String getDate(String string) {
        return new SimpleDateFormat(string).format(this.getDate());
    }

    public TimeZone getTimeZone() {
        return this.moment.getTimeZone();
    }

    public boolean between(MomentInTime momentInTime, MomentInTime momentInTime2) {
        return this.after(momentInTime) && this.before(momentInTime2);
    }

    public boolean after(MomentInTime momentInTime) {
        MomentInTime momentInTime2 = momentInTime.convert(this.getTimeZone());
        return this.getDate().after(momentInTime2.getDate());
    }

    public boolean before(MomentInTime momentInTime) {
        MomentInTime momentInTime2 = momentInTime.convert(this.getTimeZone());
        return this.getDate().before(momentInTime2.getDate());
    }

    public String toString() {
        return this.longString();
    }

    public String timeOnlyString() {
        return new SimpleDateFormat("hh:mm a").format(this.getDate());
    }

    public String dateOnlyString() {
        return new SimpleDateFormat("MM/dd/yy").format(this.getDate());
    }

    public String longString() {
        return new SimpleDateFormat("MM/dd/yy hh:mm a").format(this.getDate()) + " [" + this.getTimeZoneName() + "]";
    }

    public String noTimeZoneString() {
        return new SimpleDateFormat("MM/dd/yy hh:mm a").format(this.getDate());
    }

    public int totalOffset() {
        return this.moment.get(15) + this.moment.get(16);
    }

    public MomentInTime convert(TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTime(this.getDate());
        int n = gregorianCalendar.get(15) + gregorianCalendar.get(16);
        ((Calendar)gregorianCalendar).add(14, n - this.totalOffset());
        return new MomentInTime(gregorianCalendar.getTime(), timeZone);
    }
}

